'''Developed at the Centre for GIS, Georgia Institute of Technology 
Developed by Ryan Bowman, Sivakumar Ramachandra and Manasvini Sethuraman'''
import arcpy
from arcpy import env
import pypyodbc
from time import gmtime, strftime
arcpy.env.overwriteOutput = True
class FieldException(Exception):
    def __init__(self, value):
        self.value =  value
    def __str__(self):
        return repr(self.value)

#write data read from MS Access database (which contains the results from iTree) to a csv file
def writeToCSV( tree_effects,columns, csv_file_name):
    
    out_file = open(csv_file_name,"w")
    write_str = ''
    for c in columns:
        write_str += c + ', '
    write_str = write_str[:len(write_str)-2]
    out_file.write(write_str + '\n')

    for tree_id in tree_effects.keys():
        write_str = ''
        for c in columns:
            if c not in tree_effects[tree_id].keys():
                write_str += str(tree_id) + ', '
            else:
                write_str += str(tree_effects[tree_id][c]) +', '
        write_str = write_str[:len(write_str)-2]
        
        out_file.write(write_str + '\n')
    out_file.close()

#create a geodataset from the csv by using a table to table conversion
def createGeoDataset(csv_file_name, workspace, tablename):
    inTable = csv_file_name
    outLocation = workspace
    outTable = "report_"+ tablename
    
    if arcpy.Exists(workspace + '/'+outTable):
        arcpy.Delete_management(workspace + '/'+outTable)
    
    # Execute TableToTable
    try:
        arcpy.TableToTable_conversion(inTable, outLocation, outTable)
    except Exception, e:
        arcpy.AddError(inTable)
        arcpy.AddError(outTable)
        arcpy.AddError(outLocation)
        
        arcpy.AddError(e.message)
    
#join the newly created table with the tree IDs from the orinal feature file which was provided as input to iTree
def createJoin(workspace, feature_file, cols, tablename):
    
    columns = [col.lower() for col in cols]
    
    # Set local variables    
    inFeatures = feature_file
    layerName = feature_file[feature_file.rfind('\\')+1:]
    joinTable = workspace + "/report_"+tablename
    joinField = "treeid"

    fieldList1 = arcpy.ListFields(inFeatures)
    fieldList2 = arcpy.ListFields(joinTable)
    field_list1 = []
    field_list2 = []
    for field in fieldList1:
        field_list1.append("{0}".format(field.name).lower())
    for field in fieldList2:
        if (field.name) in columns:
            field_list2.append("{0}".format(field.name).lower()) 
    
    if joinField in field_list1 and joinField in field_list2:
        outFeature = workspace +"/" + layerName + "_" + tablename
        
        # Create a feature layer from the vegtype featureclass
        if arcpy.Exists(outFeature):
            arcpy.Delete_management(outFeature)

        
        arcpy.MakeFeatureLayer_management (inFeatures, layerName)
        
        # Join the feature layer to a table
        arcpy.AddJoin_management(layerName, joinField, joinTable, joinField)
        if arcpy.Exists(workspace + '/'+layerName + "_"+tablename) == False:
            arcpy.CreateFeatureclass_management(workspace ,layerName + "_"+tablename)
        arcpy.CopyFeatures_management(layerName, outFeature)

        
        
       
        fieldList3 = arcpy.ListFields(outFeature)
        

        new_col_names = ['{0}'.format(field.name) for field in fieldList3]
        
        for field in fieldList3:
           
            if '{0}'.format(field.name).find(layerName) != -1 and '{0}'.format(field.name).find(layerName) != 'OBJECTID'and '{0}'.format(field.name).find(layerName) != 'SHAPE':
                
                arcpy.DeleteField_management(outFeature, '{0}'.format(field.name))
            elif  '{0}'.format(field.name).find("report_"+tablename) != -1:
               
                if '{0}'.format(field.name)[len('report_'+tablename+ "_") :] not in new_col_names:
                   
                    arcpy.AlterField_management(outFeature, '{0}'.format(field.name),'{0}'.format(field.name)[len('report_'+tablename+ "_") :])
                else:
                    arcpy.DeleteField_management(outFeature, '{0}'.format(field.name))

    else:
        arcpy.AddError("The iTree results cannot be joined to the input geodataset because the two tables do not have a common field")
    


try:
    database = arcpy.GetParameterAsText(0)
    feature_file = arcpy.GetParameterAsText(1)
    workspace = feature_file[:feature_file.rfind('\\')]
    folder = workspace[:workspace.rfind('\\')]
    
    tablenames = ["IndividualTreePollutionEffects","IndividualTreeOtherEffects","IndividualTreeEffects"]
    

    fieldList = arcpy.ListFields(feature_file)
    field_list = []
    for field in fieldList:
       field_list.append("{0}".format(field.name)) 

    if 'TreeID' not in field_list:
        raise FieldException('The geodataset and the iTree results cannot be joined because the geodataset does not have the field TreeID')



    ischecked = arcpy.GetParameterAsText(2)
    #perform optional backup of existing data
    layerName = feature_file[feature_file.rfind('\\')+1:]
    if str(ischecked) == 'true':
        for table in tablenames:
            if arcpy.Exists(workspace +"/" + layerName + "_" + table):
                current_time = strftime("%Y_%m_%d_%H_%M_%S", gmtime())
                arcpy.Copy_management(workspace +"/" + layerName + "_" + table, workspace +"/" + layerName + "_" + table + "_backup_" + current_time )


    fields = ["TreeID","X","Y"]
    fc = feature_file

    coords = {}
    with arcpy.da.SearchCursor(fc, fields) as cursor:
            #read each record from the gdb
            for r in cursor:
                coords[r[0]] = (r[1],r[2])
    try:
        # connect to the database
        conn = pypyodbc.connect(u'''Driver={Microsoft Access Driver (*.mdb)};DBQ='''+ database , unicode_results = True, readonly = False)
        # create a cursor
        cur = conn.cursor()
        # extract all the data
        for tablename in tablenames:
            
            tree_effects = {}
            sql = "select * from %s" %tablenames[0]
            cur.execute(sql)
            result = cur.fetchall()
            for row in result:
                #arcpy.AddMessage("id="+str(row[0]))
                tree_effects.update({row[3] :{}})
            sql = "select * from %s" %tablename
            
            cur.execute(sql)
            
            #collect all the columns in this table
            cols = [str(cur.description[i][0]) for i in range(len(cur.description))]
            cols.append('X')
            cols.append('Y')
            if 'TreeId' not in cols and 'treeid' not in cols:
                raise FieldException('The table ' + tablename + ' in the results database does not have a TreeID field ')
            
            #fetch all the data from this table
            result = cur.fetchall()
            
            for row in result:
                #collect the data into a dictionary
                for i in range(3, len(row)):
                    tree_effects[row[3]][cols[i]] = row[i]
                    tree_effects[row[3]]['X'] = coords[row[3]][0]
                    tree_effects[row[3]]['Y'] = coords[row[3]][1]
                    
                
            csv_file_name = folder + "\\results.csv"
            #write the collected data into a csv
            
            writeToCSV(tree_effects,cols, csv_file_name)
            #create a geotable using the csv
            createGeoDataset(csv_file_name,workspace, tablename) 
            #join the iTree results to the geodataset
            createJoin(workspace, feature_file, cols, tablename)


        
    except FieldException as e:
        arcpy.AddError(e.value)
    except Exception, e:
        arcpy.AddError("One or more of the tables from the iTree results was found to be missing or corrupted. Please make sure that the three tables IndividualTreePollutionEffects, IndividualTreeOtherEffects, IndividualTreeEffects are all present in the input database")
    
    finally:      
        cur.commit()
        cur.close()
        conn.close()

        
except FieldException as e:
    arcpy.AddError(e.value)
    
    
