'''Developed at the Centre for GIS, Georgia Institute of Technology 
Developed by Ryan Bowman, Sivakumar Ramachandra and Manasvini Sethuraman'''
import arcpy
from arcpy import env
import pypyodbc

def validateEntry(row, fields):
    errors = {}
   #validation method. Checks for errors in values provided for the fields in the table, and writes the errors to a file.
    num_errors = 0
    
    for i in range(len(row)):
        

        if row[i] != None:
            if fields[i] == 'TreeID':
                if row[i] <= 0:
                    errors[fields[i]] = 'You entered TreeID as ' + str(row[i]) + " but TreeID should be greater than 0"
                else:
                    errors[fields[i]] = ''
            if fields[i] == 'STAT':
                err = ''
                if row[i] == 'R' or row[i] == 'H' or row[i] == 'C' or row[i] == 'L':
                    rem_fields = ['DBHHT','DBH1','DBH2','DBH3','DBH4','DBH5','DBH6','TOTHT','LiveTop','CrownBase','CrownWidthNS','crownWidthEW','PercentCrwnMissing','CrownDieBack']
                    for f in rem_fields:
                        if row[row.inde(f)] != -1:
                            err = f +'=' + str(row[row.index(f)]) +'\t should be -1 for removed tree'
                            errors[f] = err
                            err += 1
                    for e in fields:
                        if e not in errors:
                            #arcpy.AddMessage(e)
                            errors[e] = ''
                    return num_errors, errors

            if fields[i] == "TOTHT":
                err = ''
                if row[i] < row[fields.index('LiveTop')]:
                    err += " You entered total height as "+str(row[i])+ " and live top as "+ str( row[len(row) - 1]) +" but live Top should be less than or equal to total height"
                    num_errors += 1               
            
                
                if row[i] < 0 or row[i] > 150:
                    err +="\t You entered " +  fields[i] + "as "+ str(row[i]) + "\t but Tree height should be  less than or equal to 150"
                    num_errors += 1
                if fields[i] not in errors:
                    errors[fields[i]] = err
            
            if fields[i] == "DBH1" or fields[i] == "DBH2" or fields[i] == "DBH3" or fields[i] == "DBH4" or fields[i] == "DBH5" or fields[i] == "DBH6":
                
                if fields[i] == 'DBH1':
                    if row[i] > 0  and row[i] < 0.5 or row[i] > 200:                    
                        errors[fields[i]] = "You entered " + fields[i]+ " as " + str(row[i]) + " " + fields[i] + " but it should be in the range of 0.5 to 200"
                        num_errors += 1
                    else:
                        errors[fields[i]] = ''
                elif  fields[i] !='DBH1':
                    if row[i] > 0  and row[i] < 0.5 or row[i] > 200:
                        if row[i] != -1:
                            errors[fields[i]] = "You entered " + fields[i]+ " as " + str(row[i]) + " " + fields[i] + " but it should be in the range of 0.5 to 200 or -1"
                            num_errors += 1
                        else:
                            errors[fields[i]] = ''
                    else:
                        errors[fields[i]] = ''

            if fields[i] == "CrownBase":
                if row[i] < 0  or row[i] > 450:
                    errors[fields[i]] = "You entered " + fields[i] + " as " + str(row[i]) + " but crown base should be  in the range of 0 to 450 "
                    num_errors += 1
                else:
                    if fields[i] not in errors:
                        errors[fields[i]] = ''
            if fields[i] == "CrownWidthNS":          
                if row[i] > 0  and row[i] < 0.5 or row[i] > 150:
                    errors[fields[i]]= "You entered " + fields[i] + " as " + str(row[i]) + " but crown width 1 should be  in the range of 0 to 150 "
                    num_errors += 1
                else:
                    if fields[i] not in errors:
                        errors[fields[i]] = ''
            if fields[i] == "CrownWidthEW":          
                if row[i] > 0  and row[i] < 0.5 or row[i] > 150 :
                    errors[fields[i]] = "You entered " + fields[i] + " as " + str(row[i]) + " but crown width 2 should be  in the range of 0 to 150 "
                    num_errors += 1
                else:
                    if fields[i] not in errors:
                        errors[fields[i]] = ''
            if fields[i] == "PercentCrownMissing":
                err = ''
                if row[i]  == 100:
                    if row[fields.index('LiveTop')] != -1:
                        errors['LiveTop'] = 'You entered LiveTop as ' + str(row[fields.index('LiveTop')]) + ' but LiveTop should be -1 for dead tree'
                        num_errors += 1
                    if row[fields.index('CLE')] != -1:
                        errors['CLE'] = 'You entered CLE as '  + str(row[fields.index('CLE')]) + " but CLE should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownBase')] != -1:
                        errors['CrownBase'] = 'Youe entered CrownBase' + ' as ' + str(row[fields.index('CrownBase')]) + " but CrownBase should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownWidthNS')] != -1:
                        errors['CrownWidthNS'] = 'You entered CrownWidthNS' + ' as ' + str(row[fields.index('CrownWidthNS')]) + " but CrownWidthNS should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownWidthEW')] != -1:
                        errors['CrownWidthEW'] = 'You entered CrownWidthEW' + ' as ' + str(row[fields.index('CrownWidthEW')]) + " but CrownWidthEW should be -1 for a dead tree"
                        num_errors +=1
                if row[i] < 0 or row[i] > 100:
                   
                    err = "You entered " + fields[i] + " as " + str(row[i]) + " but Percentage crown missing should be in the range of 0 and 100"
                    num_errors += 1
                else:
                    err = ''
                if fields[i] not in errors:
                    errors[fields[i]] = err

            if fields[i] == "CrownDieback":
                err = ''
                if row[i] == 100:
                    if row[fields.index('LiveTop')] != -1:
                        errors['LiveTop'] = 'You entered LiveTop as  ' + str(row[fields.index('LiveTop')]) + ' but LiveTop should be -1 for dead tree'
                        num_errors += 1
                    if row[fields.index('CLE')] != -1:
                        errors['CLE'] = 'You entered CLE' + ' as ' + str(row[fields.index('CLE')]) + " but CLE should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownBase')] != -1:
                        errors['CrownBase'] = 'You entered CrownBase' + ' as ' + str(row[fields.index('CrownBase')]) + " but CrownBase should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownWidthNS')] != -1:
                        errors['CrownWidthNS'] = 'You entered CrownWidthNS' + ' as ' + str(row[fields.index('CrownWidthNS')]) + " but CrownWidthNS should be -1 for a dead tree"
                        num_errors +=1
                    if row[fields.index('CrownWidthEW')] != -1:
                        errors['CrownWidthEW'] = 'You entered CrownWidthEW' + ' as ' + str(row[fields.index('CrownWidthEW')]) + " but CrownWidthEW should be -1 for a dead tree"
                        num_errors +=1
                if row[i] < 0 or row[i] > 100:                    
                    err = "You entered " + fields[i] + " as " + str(row[i]) +  " but Dieback should be in the range of 0 and 100"
                    num_errors += 1
                else:
                    errors[fields[i]] = ''
                
                errors[fields[i]] = err
            if fields[i] == "CLE":
                err = ''
                if row[i] < 0 or row[i] > 5:                    
                    err = "You entered " + fields[i] + " as " + str(row[i]) + " but CLE should be in the range of 0 and 5"
                    num_errors += 1
                else:
                    if fields[i] not in errors:
                        err = ''
                if 'CLE' not in errors:
                    errors[fields[i]] = err
            if fields[i] == 'DBHHT':
                if row[i] <= 0.1 or row[i] > 6:
                    
                    errors[fields[i]] = "You entered " + fields[i] + " as " + str(row[i]) + " but DBHHT should be in the range of 0.1 and 6"
                    num_errors += 1
                else:
                    
                    errors[fields[i]] = ''
            
        else:
            errors[fields[i]] = ''
    return num_errors, errors



def checkTypes(row, fields):
    r = []
    for i in range(len(row)):
        if row[i] != None:
            if fields[i].lower() == 'treeid'  or fields[i].lower() == 'cle' or fields[i].lower() == 'cle' or fields[i].lower() == 'crowndieback' or fields[i].lower() == 'percentcrownmissing':
                r.append(int(row[i]))
            elif fields[i].lower() == 'x' or fields[i].lower() == 'y' or fields[i].lower() == 'dbh1' or fields[i].lower() == 'dbh2' or fields[i].lower() == 'dbh3' or fields[i].lower() == 'dbh4' or fields[i].lower() == 'dbh5' or fields[i].lower() == 'dbh6' or  fields[i].lower() == 'totht' or fields[i].lower() == 'crownwidthew' or fields[i].lower() == 'crownwidthns' or fields[i].lower() == 'crownbase' or fields[i].lower() == 'dbhht' or fields[i].lower() == 'livetop':
                r.append(float(row[i]))
            elif fields[i].lower() == 'date' or fields[i].lower() == 'species' or fields[i].lower() == 'comments' or fields[i].lower() == 'crew' or fields[i].lower() == 'photoid' or fields[i].lower() == 'stat' or fields[i].lower() == 'treeaddress' or fields[i].lower() == 'treesite' or fields[i].lower() == 'fieldlanduse' :
                r.append(str(row[i]))
        else:
            r.append('')
    
    return r


#get parameters from arcmap
dbfile = arcpy.GetParameterAsText(0)
gdb_table = arcpy.GetParameterAsText(1)
database = dbfile
try:
#Connect to MS Access Database created in the previous step
    conn = pypyodbc.connect(u'''Driver={Microsoft Access Driver (*.mdb)};DBQ='''+ dbfile , unicode_results = True, readonly = False)
    cur = conn.cursor()

    #Get the list of fields in the database
    cur.execute("select 1 from FullInventoryTrees")
    
    fc = gdb_table
    dataset = gdb_table
    arcpy.CalculateField_management(dataset, "X", "!Shape!.firstPoint.X","PYTHON_9.3","")
    arcpy.CalculateField_management(dataset, "Y", "!Shape!.firstPoint.Y","PYTHON_9.3","")

    #Get the fields in the geodataset
    fieldList = arcpy.ListFields(gdb_table)
    field_list = []
    for field in fieldList:
       field_list.append("{0}".format(field.name).lower()) 


    #List fields required by iTree       
    fields = ["TreeID","X","Y","Date","Species", "DBH1","DBH2","DBH3","DBH4","DBH5","DBH6","TOTHT","CrownBase","CrownWidthNS","CrownWidthEW","PercentCrownMissing","CrownDieback","CLE","Comments","Crew","PhotoID","STAT","LiveTop","TreeAddress", "TreeSite","FieldLandUse", "DBHHT"]

    #Open up a .csv file for logging errors
    file_writer = open(r''+ dbfile[:dbfile.rfind('\\')]+ '/' + 'error_log_' +  dbfile[dbfile.rfind('\\')+1:dbfile.find('.mdb')] + '.csv', 'w')
    err_fields = [ "TOTHT","DBH1","DBH2","DBH3","DBH4","DBH5","DBH6","CrownBase","CrownWidthNS","CrownWidthEW","PercentCrownMissing","CrownDieback","CLE", "DBHHT"]
    file_writer.write('TreeID, Species, DBH1, '+ ', ' .join(err_fields))
    file_writer.write('\n')

    #Date column name formatting
    if 'Date_' in field_list:
        fields[fields.index('Date')] = 'Date_'

    #Check if all the required fields are present in the geodataset
    missing_fields = []
    flag = 1
    for field in fields:
        if field.lower() not in field_list:
            flag = 0
            missing_fields.append(field)
    #if all fields are present, proceed to populate the Access database
    
    if flag == 1:

        try:    
            with arcpy.da.SearchCursor(fc, fields) as cursor:
                #read each record from the gdb
                for r in cursor:
                    #validate the record
                    row = [r[i] for i in range(len(fields))]
                    row = checkTypes(row, fields)
                    if row[fields.index('Comments')] != None:
                        idx = row[fields.index('Comments')].find('\'') 
                        if idx != -1:
                            row[fields.index('Comments')] = row[fields.index('Comments')].replace("'","''")
                            

                    
                    num_errors, errors = validateEntry(row, fields)
                    
                    #if there are no errors in the data, write it to the MS Access database
                    if num_errors == 0:
                        
                        query = "SELECT TreeID from FullInventoryTrees where TreeID=" + str(r[0])
                        
                        cur.execute(query)
                        res = cur.fetchall()
                        
                        if len(res) == 0: 
                            arcpy.AddMessage("adding TreeID"+str(row[0]))
                            
                            query = "INSERT INTO FullInventoryTrees values(%d,%f,%f,'%s','%s',%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%d,'%s','%s','%s','%s',%f,'%s','%s','%s',%f)" %(row[0],row[1],row[2],row[3],row[4],row[5],row[6],row[7],row[8],row[9],row[10],row[11],row[12],row[13],row[14],row[15],row[16],row[17],row[18], row[19], row[20],row[21],row[22],row[23],row[24],row[25],row[26])
                           
                            cur.execute(query)
                    #log the errors in the csv file
                    else:
                        errors_list = [errors[e] for e in err_fields]
                        file_writer.write(str(row[0]) +', '+ str(row[4]) +', '+ str(row[5])+ ', ' .join(errors_list))
                        file_writer.write('\n')
                
        except Exception, e:
            arcpy.AddMessage("Error: " + str(e.message))
        

    else:
        arcpy.AddMessage("One or more of the fields required for processing by iTree we not found in the specified geodatasetsTHe fields " + ','.join(missing_fields) + " were not found")

except Exception, e:
    arcpy.AddError("The table FullInventory Trees, required by iTree was not found in the input databaseor is locked. Please check the mdb file")

finally:
    cur.commit()
    cur.close()
    conn.close()

       
    
