'''Developed at the Centre for GIS, Georgia Institute of Technology 
Developed by Ryan Bowman, Sivakumar Ramachandra and Manasvini Sethuraman'''
import arcpy
import pypyodbc
from arcpy import env
import os.path
#get parameters from ArcMap
folder = arcpy.GetParameterAsText(0)
dbname = arcpy.GetParameterAsText(1)


if os.path.isfile( folder + '/'+ dbname + '.mdb') == True: 
	arcpy.AddError("File already exists. Please choose a different file name and run again")
else:
	try:
	    #create the database with the name specified in the parameter
	    pypyodbc.win_create_mdb( folder + '/'+ dbname + '.mdb' )
	    #Establish connection to the database
	    conn = pypyodbc.connect(u'''Driver={Microsoft Access Driver (*.mdb)};DBQ='''+ folder + '/'+ dbname + '.mdb', unicode_results = True, readonly = False)
	except Exception, e:
	    arcpy.AddError(e)
	    
	env.overwriteOutput = True

	#Create the table within the database
	sql = "CREATE TABLE FullInventoryTrees(TreeId Integer PRIMARY KEY,X Double, Y Double, [Date] DATETIME, SPECIES Text, DBH1 Single, DBH2 Single, DBH3 Single, DBH4 Single, DBH5 Single, DBH6 Single, TOTHT Single, CROWNBASE Single, CROWNWIDTHNS Single, CROWNWIDTHEW Single, PERCENTCROWNMISSING Integer, CROWNDIEBACK Integer, CLE Integer, COMMENTS Text, Crew Text, PhotoId Text,  STAT Text, LiveTop Double, TreeAddress Text, TreeSite Text, FieldLandUse Text, DBHHT Double )"
	conn = pypyodbc.connect(u'''Driver={Microsoft Access Driver (*.mdb)};DBQ='''+ folder + '/'+ dbname + '.mdb', unicode_results = True, readonly = False)
	cur = conn.cursor()
	cur.execute(sql)

	#clean up
	cur.close()
	cur.commit()
	conn.close()
